package javabeans;

public class Thermostat implements TempChangeListener {
	private PointChaud pointChaud;

	public Thermostat(PointChaud pointChaud) {
		this.pointChaud = pointChaud;
		this.pointChaud.addTempChangeListener(this);
	}
	
	public void retirer(){
		this.pointChaud.removeTempChangeListener(this);
		this.pointChaud = null;
	}
	
	public PointChaud getPointChaud() {
		return pointChaud;
	}

	public void poserSur(PointChaud PointChaud) {
		if (this.pointChaud != PointChaud){
			this.pointChaud.removeTempChangeListener(this);
			
			this.pointChaud = PointChaud;
			this.pointChaud.addTempChangeListener(this);
		}
	}

	public void tempChanged(TempChangedEvent event) {
		System.out.println("Notification nouvelle temperature = " + event.getPointChaud());
	}

	
	@Override
	public String toString() {
		if (pointChaud == null){
			return "(Thermostat : sans point chaud associe)";
		}
		return "(Thermostat : " + pointChaud.getPointChaud() + ")";
	}
}

